%% Copyright (c) 2017, Wagatsuma Lab@Kyutech and Hiroaki Wagatsuma 
%%
%% All rights reserved. This code was developed in the version of MATLAB 2014a
%%
%% Redistribution and use in source and binary forms, with or without
%% modification, are permitted under the terms of the Creative Commons License
%% Attribution, BY "Wagatsuma Lab@Kyutech and Hiroaki Wagatsuma "
%%  Symbolic Math Toolbox is necessary. This code was varidated in Symbolic Math Toolbox Ver 6.0  (R2014a)
% Version 2.0
% Ver 0.0 : one dimensional vector, aj is acceptable but matrix with 2 dimensional structure, aij is not acceptable 
% Ver 1.0 -> 2.0: a_{3}\, x_^_{2} + a_{2}\, x_ + a_{1} / Missing { inserted.<to be read again>                    ^                   ^l.8 \end{align*}                /var/folders/mg/w5t8lkhc8xj79f001s7kzpfh0000gn/T/LaTeXiT-2.8.1/latexit-1.tex8 Missing { inserted.<to be read again>                    _l.8 \end{align*}                /var/folders/mg/w5t8lkhc8xj79f001s7kzpfh0000gn/T/LaTeXiT-2.8.1/latexit-1.tex8 Missing } inserted.<inserted text>                 }l.8 \end{align*}                /var/folders/mg/w5t8lkhc8xj79f001s7kzpfh0000gn/T/LaTeXiT-2.8.1/latexit-1.tex8 Missing } inserted.<inserted text>                 }l.8 \end{align*}                /var/folders/mg/w5t8lkhc8xj79f001s7kzpfh0000gn/T/LaTeXiT-2.8.1/latexit-1.tex8 Missing { inserted.<to be read again>                    ^l.8 \end{align*}                /var/folders/mg/w5t8lkhc8xj79f001s7kzpfh0000gn/T/LaTeXiT-2.8.1/latexit-1.tex8 Missing { inserted.<to be read again>                    _l.8 \end{align*}                /var/folders/mg/w5t8lkhc8xj79f001s7kzpfh0000gn/T/LaTeXiT-2.8.1/latexit-1.tex8 Missing } inserted.<inserted text>                 }l.8 \end{align*}                /var/folders/mg/w5t8lkhc8xj79f001s7kzpfh0000gn/T/LaTeXiT-2.8.1/latexit-1.tex8 Missing } inserted.<inserted text>                 }l.8 \end{align*}                [1] (./latexit-1.aux) )(see the transcript file for additional information)Output written on latexit-1.dvi (1 page, 496 bytes).
% Ver 1.0 -> 2.0: power '^' with number is not acceptable such as '^2'

function res=convert2TeXF2d(expF,vaRori)
% inStr=latex(Phiq_dq);
inStr=latex(expF);
vaR=getVariables(char(vaRori));
% chTex={'\alpha','\beta','\gamma','\delta','\epsilon','\zeta','\eta','\theta','\iota','\kappa','\lambda','\mu','\nu','\xi','\o','\pi','\rho','\sigma','\tau',...
%     '\upsilon','\phi','\chi','\psi','\omega','\Gamma','\Delta','\Theta','\Lambda','\Xi','\Pi','\Sigma','\Upsilon','\Phi','\Psi','\Omega','\varepsilon',...
%     '\vartheta','\varpi','\varrho','\varsigma','\varphi'};
chTex={'\alpha','\beta','\gamma','\delta','\epsilon','\zeta','\eta','\theta','\iota','\kappa','\lambda','\mu','\nu','\xi','\pi','\rho','\sigma','\tau',...
    '\upsilon','\phi','\chi','\psi','\omega','\Gamma','\Delta','\Theta','\Lambda','\Xi','\Pi','\Sigma','\Upsilon','\Phi','\Psi','\Omega','\varepsilon',...
    '\vartheta','\varpi','\varrho','\varsigma','\varphi'};

DiffN=3; diffStr={'\dot','\ddot'};
% vaR={'x','y','phi'}; 

getLeft=@(st) st(9:end-1);
putIn=@(st,num) [st(1:num+1),'_',st(num+2:end)];

tStr=inStr;
myExp='\\overline{\w*}'; myRep='${getLeft($0)}'; 
tStr = regexprep(tStr,myExp,myRep);
myExp='\\mathrm{\w*}'; myRep='${getLeft($0)}'; 
tStr = regexprep(tStr,myExp,myRep);

myExp='{array}'; myRep='<array>'; 
tStr = regexprep(tStr,myExp,myRep);
myExp='{\D*}'; myRep='<$0>'; 
tStr = regexprep(tStr,myExp,myRep);
% myExp='{c}'; myRep='!c!'; 
% tStr = regexprep(tStr,myExp,myRep);

myExp='{|}'; myRep=''; 
tStr = regexprep(tStr,myExp,myRep);
myExp='!array!'; myRep='{array}'; 
tStr = regexprep(tStr,myExp,myRep);
myExp='!c!'; myRep='{c}'; 
tStr = regexprep(tStr,myExp,myRep);

myExp='\d*_\d*'; myRep='_{$0}'; % 'a1_1' - > 'a_{1_1}'
tStr = regexprep(tStr,myExp,myRep);
myExp='{\d*_'; myRep='$0,'; % 'a_{1_1}' - > 'a_{1_,1}'
tStr = regexprep(tStr,myExp,myRep);
myExp='_,'; myRep=','; % 'a_{1_,1}' - > 'a_{1,1}'
tStr = regexprep(tStr,myExp,myRep);

myExp='(?<!({\d|\^))\d*(?!})'; myRep='_{$0}'; % ver 2.0: a3\, x^2 + a2\, x + a1 -> a_{3}\, x^2 + a_{2}\, x + a_{1}
% myExp='(?<!\^)\d*(?!})'; myRep='_{$0}'; % 'x1' - > 'x_1'

tStr = regexprep(tStr,myExp,myRep);
myExp='{_'; myRep='{'; % 'a_{_124,512}' - > 'a_{124,512}'
tStr = regexprep(tStr,myExp,myRep);
myExp=',_'; myRep=','; % 'a_{124,_512}' - > 'a_{124,512}'
tStr = regexprep(tStr,myExp,myRep);

myExp='<array>'; myRep='{array}'; 
tStr = regexprep(tStr,myExp,myRep);

myExp=' _'; myRep=' '; 
tStr = regexprep(tStr,myExp,myRep);
myExp='>'; myRep='}'; 
tStr = regexprep(tStr,myExp,myRep);
myExp='<'; myRep='{'; 
tStr = regexprep(tStr,myExp,myRep);
myExp='__{'; myRep='_{'; 
tStr = regexprep(tStr,myExp,myRep);
% tStr=inStr; 

for kj=1:length(vaR) % the number of variables
    for ki=DiffN:-1:1 % the maximum order of differentials  
        if ki>2 
            myExp=[repmat('d',[1,ki]),vaR{kj}]; myRep=[vaR{kj},'^(',ki,')'];
        else
            myExp=[repmat('d',[1,ki]),vaR{kj}]; 
%             if ki==1 myRep=['\dot ',vaR{kj}];
             switch ki
                 case 1
                     myRep=['\dot ',vaR{kj}];
                 case 2
                     myRep=['\ddot ',vaR{kj}];
                 otherwise
                     myRep=myExp;
             end
        end
        tStr = strrep(tStr,myExp,myRep);
        
    end
    myExp=['[ ({\[\./+-*/]',vaR{kj},'\d*[^_]']; myRep=['${putIn($0,',num2str(length(vaR{kj})),')}'];
    tStr = regexprep(tStr,myExp,myRep);  
end

for kk=1:length(chTex)
    myRep=chTex{kk}; myExp=myRep(2:end); 
    tStr = strrep(tStr,myExp,myRep);
end

myExp=' 1\,'; myRep=' '; 
tStr = strrep(tStr,myExp,myRep);
myExp='__{'; myRep='_{'; 
tStr = regexprep(tStr,myExp,myRep);
myExp='_\^'; myRep='\^'; 
tStr = regexprep(tStr,myExp,myRep); % Ver 2.0: x_^2 
myExp='_ '; myRep=' '; 
tStr = regexprep(tStr,myExp,myRep); % Ver 2.0 : x_ + a_{1}


myExp='\\overline'; myRep=''; 
tStr = regexprep(tStr,myExp,myRep);

myExp='\\conj(\w*)'; myRep='${getLeft($0)}'; 
tStr = regexprep(tStr,myExp,myRep);

res=tStr;

end

function res=getVariables(tVal)
    myExp='matrix([[';  myRep=''; 
    tVal = strrep(tVal,myExp,myRep);
    myExp=' [';  myRep=''; 
    tVal = strrep(tVal,myExp,myRep);
    myExp=']';  myRep=''; 
    tVal = strrep(tVal,myExp,myRep);
    myExp=')';  myRep=''; 
    tVal = strrep(tVal,myExp,myRep);
    cellVal=strsplit(tVal,',');

    myExp='\d*'; myRep='';
    rmCh= @(x) regexprep(x,myExp,myRep);

    cellVal2= cellfun(rmCh, cellVal, 'UniformOutput', false);
    cellVal2=sortrows(cellVal2');
    k=2;
    % for k=2:length(cellVal2)
    while length(cellVal2)>=k
        if strcmp(cellVal2{k-1},cellVal2{k}) cellVal2(k)=[]; else k=k+1; end
    end
    
    res=cellVal2;
end